

;=====================================================================================================================================================
;																									
;	( PIEL-02 )	 		CALCULA PIEL NUEVA-COBRA en 3D y 2D															
;																									
;					( SPLINES-PLANAS  ABIERTAS en PLANOS NO PARALELOS Y UNA SOLA CURVATURA SIN PUNTOS DE INFLEXION )				
;																									
;																									
;	PLANIFICA PIEL ENTRE DOS (SPLINES-PLANAS  ABIERTAS en PLANOS NO PARALELOS Y UNA SOLA CURVATURA) (SPLINE-A) (SPLINE-B)					
;																									
;	PUNTEANDOLAS a Distancia= GRADUA-(MODU) => DIVIDE ==> ( LIS-PA ) y ( LIS-PB )												
;																									
;	PUNTOS INTERSECCION DE PLANOS de Secciones (A) y (B) => (TRAZ-1) (TRAZ-2)												
;																									
;	INERSECCION TANGENTE-( PA2 (PA1-PA3)) con TRAZA-( TRAZ-1 TRAZ-2 ) => ( POtag )											
;																									
;	DISTANCIAS de (PB1) y (PB3) a RECTA-(POtag PB2)  ( SI ((B1yy) y (B3yy)) son del MISMO SIGNO  => (POtag-PB2)=(TANGENTE a (SPLINE-B))			
;																									
;	FORMA CARA (3A1 3A2 3B1 3B2) INTERSECCION de (3 TANG-A)=> (3A1 3A2) y (3 TANG-B)=> (3B1 3B2) 	*** (PINTA-3D-2D) ***					
;																									
;																									
;=====================================================================================================================================================



;=====================================================================================================================================================
;																									
;									*** ***  SUB-PROGRAMAS  *** ***											
;																									
;=====================================================================================================================================================


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	SPLINE-A   GRADUA	y DIVIDE => ( LIS-PA )  																	

	(DEFUN SPLI-A ( / )

		(SETQ SA00 (ENTSEL" MARCA --- SPLINE ABIERTA-3D --- SECCION-A ? ")) (TERPRI)
		(SETQ NA00  (CAR SA00)) 									; nombre Spline A 
		(SETQ ALIS  (ENTGET NA00))  									; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 								; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ A-primer (CDR (NTH 0 AELES))) 							; primer elemento (10.punto)
		(SETQ A-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))				; ultimo elemento (11.punto)
		(COMMAND "color" 1 "TEXTO" A-primer 0.2 0 "A")						; TEXTO = A
		(COMMAND "PUNTO" A-primer)									; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))									; nombre ultima entidad principal 1 punto A
		(COMMAND "GRADUA" NA00 MODU)									; gradua SPLI-A
		(COMMAND "PUNTO" A-ultimo)									; PINTA Ultimo Punto A
	
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PA  Lon-LPA															
		(SETQ LIS-PA nil)											; LISTA  PUNTOS-A
		(SETQ LIS-PA (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PA))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))						; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PA (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PA))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A
		;	LISTA ( LIS-PA )																				
		(SETQ LIS-PA  (REVERSE LIS-PA))
		(SETQ NPA (LENGTH LIS-PA))

		;	SPLINE-A   DIVIDE																				
		(SETQ ALIS  (ENTGET NA00))  									; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 								; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ A-primer (CDR (NTH 0 AELES))) 							; primer elemento (10.punto)
		(SETQ A-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))				; ultimo elemento (11.punto)
		(COMMAND "color" 1 "TEXTO" A-primer 0.2 0 "A")						; TEXTO = A
		(COMMAND "PUNTO" A-primer)									; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))									; nombre ultima entidad principal 1 punto A
		(COMMAND "DIVIDE" NA00 (- NPA 1))								; DIVIDE SPLI-A
		(COMMAND "PUNTO" A-ultimo)									; PINTA Ultimo Punto A
	
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PA  Lon-LPA															
		(SETQ LIS-PA nil)											; LISTA  PUNTOS-A
		(SETQ LIS-PA (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PA))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))						; Nombre entidad siguiente
			;(COMMAND "BORRA" N-enti-A1 "")
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PA (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PA))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A
		;	LISTA ( LIS-PA )																				
		(SETQ LIS-PA  (REVERSE LIS-PA))
		;  (LENGTH LIS-PA)

	) ; Defun SPLI-A

;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	SPLINE-B   GRADUA	y DIVIDE => ( LIS-PB ) 																		

	(DEFUN SPLI-B ( / )

		(SETQ SB00 (ENTSEL" MARCA --- SPLINE ABIERTA 3D --- SECCION-B ? ")) (TERPRI) (TERPRI)
		(SETQ NB00  (CAR SB00)) 									; nombre Spline B 
		(SETQ BLIS  (ENTGET NB00))  									; lista Spline B 
		(SETQ BELE  (ASSOC 10 BLIS))  								; 1 Punto Asociado a 10 (10.punto)
		(SETQ BELES (MEMBER BELE BLIS)) 								; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ B-primer (CDR (NTH 0 BELES))) 							; primer elemento (10.punto)
		(SETQ B-ultimo (CDR (NTH (- (LENGTH BELES) 1) BELES))) 				; ultimo elemento (11.punto)
		(COMMAND "color" 5 "TEXTO" B-primer 0.2 0 "B")						; TEXTO = B
		(COMMAND "PUNTO" B-primer)									; PINTA 1 punto B
		(SETQ N-enti-B1 (ENTLAST))									; nombre ultima entidad principal 1 punto B
		(COMMAND "GRADUA" NB00 MODU)									; gradua SPLI-B
		(COMMAND "PUNTO" B-ultimo)									; PINTA Ultimo Punto B

		;	PUNTOS SECCION-B (PB1-PBn) => LIS-NB  LIS-PB  Lon-LPB													-
		(SETQ LIS-PB  nil)										; LISTA  PUNTOS-B
		(SETQ LIS-PB (CONS (CDR (ASSOC 10 (ENTGET N-enti-B1))) LIS-PB)) 			; lista entidad  -> (1 Punto-B)
		(SETQ W1B T)
		(WHILE W1B
			(SETQ N-enti-B2 (ENTNEXT N-enti-B1))						; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-B1 "")
			(IF (= N-enti-B2 nil) (SETQ W1B nil)
				(PROGN
					(SETQ LIS-PB (CONS (CDR (ASSOC 10 (ENTGET N-enti-B2))) LIS-PB))
					(SETQ N-enti-B1  N-enti-B2 )
				);progn
			);if
		) ;While W1B
		;	LISTA ( LIS-PB )																				
		(SETQ LIS-PB  (REVERSE LIS-PB))
		(SETQ NPB (LENGTH LIS-PB))

		;	SPLINE-B   DIVIDE																				
		(SETQ BLIS  (ENTGET NB00))  									; lista Spline B 
		(SETQ BELE  (ASSOC 10 BLIS))  								; 1 Punto Asociado a 10 (10.punto)
		(SETQ BELES (MEMBER BELE BLIS)) 								; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ B-primer (CDR (NTH 0 BELES))) 							; primer elemento (10.punto)
		(SETQ B-ultimo (CDR (NTH (- (LENGTH BELES) 1) BELES))) 				; ultimo elemento (11.punto)
		(COMMAND "color" 5 "TEXTO" B-primer 0.2 0 "B")						; TEXTO = B
		(COMMAND "PUNTO" B-primer)									; PINTA 1 punto B
		(SETQ N-enti-B1 (ENTLAST))									; nombre ultima entidad principal 1 punto B
		(COMMAND "DIVIDE" NB00 (- NPB 1))								; DIVIDE SPLI-B
		(COMMAND "PUNTO" B-ultimo)									; PINTA Ultimo Punto B

		;	PUNTOS SECCION-B (PB1-PBn) => LIS-NB  LIS-PB  Lon-LPB													-
		(SETQ LIS-PB  nil)										; LISTA  PUNTOS-B
		(SETQ LIS-PB (CONS (CDR (ASSOC 10 (ENTGET N-enti-B1))) LIS-PB)) 			; lista entidad  -> (1 Punto-B)
		(SETQ W1B T)
		(WHILE W1B
			(SETQ N-enti-B2 (ENTNEXT N-enti-B1))						; Nombre entidad siguiente
			;(COMMAND "BORRA" N-enti-B1 "")
			(IF (= N-enti-B2 nil) (SETQ W1B nil)
				(PROGN
					(SETQ LIS-PB (CONS (CDR (ASSOC 10 (ENTGET N-enti-B2))) LIS-PB))
					(SETQ N-enti-B1  N-enti-B2 )
				);progn
			);if
		) ;While W1B

		;	LISTA ( LIS-PB )																				
		(SETQ LIS-PB  (REVERSE LIS-PB))
		;  (LENGTH LIS-PB)

	) ; Defun SPLI-B

;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	Puntos ** TRAZA ** de PLANOS de Secciones (A) y (B) => (TRAZ-1) (TRAZ-2)												

	(DEFUN TRAZA-AB ( / )

		(COMMAND "SCP" "B" NA00 )		; PLANO Sa
 			(SETQ Sa0 (TRANS (LIST    0   0 0) 1 0))
 			(SETQ Sa1 (TRANS (LIST  100 100 0) 1 0))
 			(SETQ Sa2 (TRANS (LIST -100 100 0) 1 0))
		(COMMAND "SCP" "U")

		(COMMAND "SCP" "B" NB00 )		; PLANO Sb
 			(SETQ Sa0b (TRANS Sa0 0 1))
 			(SETQ Sa1b (TRANS Sa1 0 1))
 			(SETQ Sa2b (TRANS Sa2 0 1))
 			(SETQ Sb0 (TRANS (LIST (CAR Sa0b) (CADR Sa0b) 0) 1 0))
 			(SETQ Sb1 (TRANS (LIST (CAR Sa1b) (CADR Sa1b) 0) 1 0))
 			(SETQ Sb2 (TRANS (LIST (CAR Sa2b) (CADR Sa2b) 0) 1 0))
		(COMMAND "SCP" "U")


		(SETQ TRAZ-1 (INTERS Sa0 Sa1 Sb0 Sb1 nil))
		(SETQ TRAZ-2 (INTERS Sa0 Sa2 Sb0 Sb2 nil))

		;(COMMAND "COLOR" 7 "LINEA" TRAZ-1 TRAZ-2 "")

	) ; Defun TRAZA-AB

;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;		PINTA CARAS en 3D y 2D																				

		(DEFUN PINTA-3D-2D ( / )

					(COMMAND "SCP" "N" "3P" 3B1 3A1 3A2)		; SCP-A

						(SETQ 2A1a (TRANS 3A1 0 1))
						(SETQ 2B1a (TRANS 3B1 0 1))
						(SETQ 2A2a (TRANS 3A2 0 1))
						(SETQ 2B2a (TRANS 3B2 0 1))

					(COMMAND "SCP" "U")

					(COMMAND "SCP" "N" "3P" 2KKB 2KKA "")		; SCP-2D

						(SETQ 2A1 (TRANS 2A1a 1 0))
						(SETQ 2B1 (TRANS 2B1a 1 0))
						(SETQ 2A2 (TRANS 2A2a 1 0))
						(SETQ 2B2 (TRANS 2B2a 1 0))

					(COMMAND "SCP" "U")

					;(COMMAND "color" 5 "3DPOL"  2A1 2B1 2B2 2A2 2A1 "" )

					(COMMAND "color" 1 "LINEA" 2A1 2A2 "" )
					(COMMAND "color" 5 "LINEA" 2B1 2B2 "" )
					(COMMAND "color" 8 "LINEA" 2A1 2B1 "" )
					(COMMAND "color" 8 "LINEA" 2A2 2B2 "" )

					(COMMAND "color" 2 "3DCARA" 3A1 3B1 3B2 3A2 "" )

					(SETQ 2KKB 2B2 2KKA 2A2) 

		) ; defun PINTA-3D-2D

;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------




;=====================================================================================================================================================
;	*** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** 		
;=====================================================================================================================================================

(DEFUN C:PIEL-02 (/ )
  
	;	ARRANCANDO																						

	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES"  "SCP" "U"  "ORTO" "DES")

	;-----------------------------------------------------------------------------------------------------------------------------------------------
	;	FIJA PARAMETROS																					
	;-----------------------------------------------------------------------------------------------------------------------------------------------


	(SETQ NCapa  (GETINT " NOMBRE de CAPA (204 ?) = ")) (TERPRI)	; N NOMBRE DE CAPA

	(SETQ MODU  0.3 )									; DISTANCIA ENTRE PUNTOS DE GRADUA (SECCION-A)

	(SETQ DIVI 4 )									; NUMERO de PUNTOS que RETROCEDE Nb (/ (LENGTH LIS-PB) DIVI )


	;-----------------------------------------------------------------------------------------------------------------------------------------------


	;																								
	;	CALCULOS																						

	(SETQ NCapa (- NCapa 1))
	(SETQ W1 T)

	(WHILE W1
		(SETQ NCapa (+ NCapa 1))
		(COMMAND "CAPA" "E" NCapa "") 					; crea y activa capa NCapa

		(SPLI-A)									; Gradua y Divide (SPLINE-A) => Puntos ( LIS-PA )
		(SPLI-B)									; Gradua y Divide (SPLINE-B) => Puntos ( LIS-PB )

		(TRAZA-AB)									; INTERSECCION PLANOS SPLINE-A SPLINE-B => (TRAZ-1) (TRAZ-2)

		;	INERSECCION TANGENTE-( PA1 PA3 en PA2 ) con TRAZA-( TRAZ-1 TRAZ-2 ) => ( POtag )									

		(SETQ Na -2 )

		(SETQ NA  0 )

		(SETQ 2KKB (LIST 0 0  0))
 		(SETQ 2KKA (LIST 0 -1 0))

		(SETQ Nb (- (/ (LENGTH LIS-PB) DIVI )))

		(SETQ  PT-A2 nil  PT-A1 nil  PT-B2 nil  PT-B1 nil )

		(SETQ LIS-ARIS1 nil)

		(REPEAT (+ (LENGTH LIS-PA) 2)								; *** *** REPEAT-LIS-PA1

			(SETQ NA (+ NA 1))

			(SETQ Na (+ Na 1))

			(IF (< Na 0) (SETQ Na (+ (LENGTH LIS-PA) Na))  )

			(SETQ PA1 (NTH (REM (+ Na 0) (LENGTH LIS-PA)) LIS-PA))
			(SETQ PA2 (NTH (REM (+ Na 1) (LENGTH LIS-PA)) LIS-PA))
			(SETQ PA3 (NTH (REM (+ Na 2) (LENGTH LIS-PA)) LIS-PA))

			;	TANGENTE-( PA1 PA3 ) en ( PA2 ) => ( PA2 PA213 )													

			(SETQ PA213 (LIST	(+ (CAR   PA2) (- (CAR   PA3) (CAR   PA1)))
						(+ (CADR  PA2) (- (CADR  PA3) (CADR  PA1)))
						(+ (CADDR PA2) (- (CADDR PA3) (CADDR PA1))) ) )

			;	SI es PARALELA ( PA2 PA213 ) a ( TRAZ-1 TRAZ-2 )  =>  ( POtag )	INTERSECCION con TRAZA							

			(COMMAND "SCP" "3P" TRAZ-1 TRAZ-2 PA2 )				; PLANO TRAZ

				(SETQ PA2-TR   (TRANS PA2   0 1))
				(SETQ PA213-TR (TRANS PA213 0 1))

				(IF (EQUAL (CADDR PA213-TR) 0 0.0000001)	   					; Coplanario ( PA213 ) con ( TRAZ-1 TRAZ-2 PA2 )

					(PROGN
						(IF (EQUAL (CADR PA2-TR) (CADR PA213-TR) 0.0000001)		; Paralela ( PA2 PA213 ) a ( TRAZ-1 TRAZ-2 )

							(SETQ POtag (TRANS (LIST 100000000000000 0 0) 1 0))	; PARALELAS
							(SETQ POtag (INTERS PA2 PA213 TRAZ-1 TRAZ-2 nil))	; SE CRUZAN

						) ; if
					) ; progn

					(PROGN
						(PROMPT "------ (PA2 PA213) y (TRAZ-1 TRAZ-2) NO SON COPLANARIAS ") (TERPRI)
					) ; progn

				) ; if

			(COMMAND "SCP" "U")


			;	DISTANCIAS de ( PB1 ) y ( PB3 ) a RECTA-( POtag  PB2 )  ( SI ( B1yy ) y ( B3yy ) son del Mismo Signo RECTA => TANGENTE )	

			(SETQ NB  0 )
			(SETQ Wb T)

			(WHILE Wb

				(SETQ NB (+ NB 1))
				(SETQ Nb (+ Nb 1))

				(IF (< Nb 0) (SETQ Nb (+ (LENGTH LIS-PB) Nb))  )

				(SETQ PB1 (NTH (REM (+ Nb 0) (LENGTH LIS-PB)) LIS-PB))
				(SETQ PB2 (NTH (REM (+ Nb 1) (LENGTH LIS-PB)) LIS-PB))
				(SETQ PB3 (NTH (REM (+ Nb 2) (LENGTH LIS-PB)) LIS-PB))

				(COMMAND "SCP" "3P" POtag PB2 TRAZ-1 )		; PLANO POtag
					(SETQ B1yy (CADR (TRANS PB1 0 1)))
					(SETQ B3yy (CADR (TRANS PB3 0 1)))
				(COMMAND "SCP" "U")

				(COND

					;( (AND (= B1yy 0) (= B3yy 0))  (SETQ  PT-A1 POtag  PT-A2 PA2  PT-B1 POtag  PT-B2 PB2  Wb nil  NNb Nb ) )
					;( (AND (= B1yy 0) (> B3yy 0))  (SETQ  PT-A1 POtag  PT-A2 PA2  PT-B1 POtag  PT-B2 PB2  Wb nil  NNb Nb ) )
					;( (AND (= B1yy 0) (< B3yy 0))  (SETQ  PT-A1 POtag  PT-A2 PA2  PT-B1 POtag  PT-B2 PB2  Wb nil  NNb Nb ) )
					;( (AND (= B3yy 0) (> B1yy 0))  (SETQ  PT-A1 POtag  PT-A2 PA2  PT-B1 POtag  PT-B2 PB2  Wb nil  NNb Nb ) )
					;( (AND (= B3yy 0) (< B1yy 0))  (SETQ  PT-A1 POtag  PT-A2 PA2  PT-B1 POtag  PT-B2 PB2  Wb nil  NNb Nb ) )

					( (AND (>= B1yy 0) (>= B3yy 0))  (SETQ  PT-A1 POtag  PT-A2 PA2  PT-B1 POtag  PT-B2 PB2  Wb nil  NNb Nb ) )
					( (AND (<= B1yy 0) (<= B3yy 0))  (SETQ  PT-A1 POtag  PT-A2 PA2  PT-B1 POtag  PT-B2 PB2  Wb nil  NNb Nb ) )

				);cond

				(IF (> NB (LENGTH LIS-PB))  (SETQ Wb nil))			; SALIDA DE SEGURIDAD DE WHILE Wb

			) ; While Wb

			(COND
				( (= NA 1) 	(SETQ  A11 PT-A2   A12 PT-A1   B11 PT-B2   B12 PT-B1 ) 		)
				( (= NA 2)  	(SETQ  A21 PT-A2   A22 PT-A1   B21 PT-B2   B22 PT-B1 )		)
				( (> NA 2)  	(SETQ  A31 PT-A2   A32 PT-A1   B31 PT-B2   B32 PT-B1 )

								(SETQ 3A1 (INTERS  A11 A12   A21 A22  nil))
								(SETQ 3B1 (INTERS  B11 B12   B21 B22  nil))

								(SETQ 3A2 (INTERS  A21 A22   A31 A32  nil))
								(SETQ 3B2 (INTERS  B21 B22   B31 B32  nil))

								;(COMMAND "COLOR" 2 "3DCARA" 3A1 3A2 3B2 3B1 "")

								(PINTA-3D-2D)

								(SETQ A11 A21   A12 A22   B11 B21   B12 B22
							 	 	A21 A31   A22 A32   B21 B31   B22 B32 ) 			)
			) ;cond

			(SETQ Nb (- NNb (/ (LENGTH LIS-PB) DIVI )))		; RETROCEDE Nb => ((N-Puntos LIS-PB) / DIVI)

		) ; repeat									; *** *** REPEAT-LIS-PA

		(TERPRI)
		(SETQ W1 (GETSTRING "QUIERE SEGUIR (S) o N : "))
		(IF (EQUAL W1 "N") (SETQ W1 nil) (SETQ W1 T))

	) ;CIERRE WHILE W1
  
	;																								

	;	PARANDO																						
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)
) ;CIERRE DEFUN PIEL-02
;=====================================================================================================================================================



